/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.repository;

import com.softjava.motor.model.Venda;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface VendaRepository
extends JpaRepository<Venda, Long> {
    public List<Venda> findFirst100ByEstadoAndSincronizadoIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse(String var1);

    public List<Venda> findFirst1000ByEstadoInAndSincronizadoIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse(List<String> var1);

    public List<Venda> findFirst100ByErroEnvioScanntechIsTrueAndScanntechErroReenvioIsFalseAndScanntechErro400IsFalse();

    public List<Venda> findFirst100ByEstadoAndSincronizadoCanceladaIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse(String var1);

    public List<Venda> findFirst100ByEstadoAndSincronizadoIsTrueAndSincronizadoCanceladaIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse(String var1);

    @Query(value="SELECT v FROM Venda v LEFT JOIN Caixa c ON v.caixa=c.id AND  c.aberto=true WHERE v.sincronizado=true AND v.estado='CANCELADA' and v.sincronizadoCancelada=false AND CAST(c.dataAbertura as LocalDate)>=:data")
    public List<Venda> findVendasCanceladaByCaixaAberto(LocalDate var1);

    @Query(value="SELECT v FROM Venda v LEFT JOIN Caixa c ON v.caixa=c.id AND c.sincronizado = false AND c.aberto=false WHERE v.sincronizado=true AND CAST(c.dataAbertura as LocalDate)>=:data AND (v.estado = 'CANCELADA' OR v.estado = 'FECHADA')")
    public List<Venda> findVendasByCaixaSincronizadoIsFalse(LocalDate var1);

    @Query(value="SELECT v FROM Venda v LEFT JOIN Caixa c ON v.caixa=c.id AND c.sincronizado = false AND c.aberto=false WHERE c.dataFechamento<=:dataFechamento AND v.sincronizado=true AND CAST(c.dataAbertura as LocalDate)>=:data AND (v.estado = 'CANCELADA' OR v.estado = 'FECHADA')")
    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndAfter1Hours(LocalDate var1, LocalDateTime var2);

    @Query(value="SELECT v FROM Venda v LEFT JOIN Caixa c ON v.caixa=c.id AND c.sincronizado = false AND c.aberto=false WHERE v.sincronizado=true AND CAST(v.dataFechamento as LocalDate)>=:data  AND (v.estado = 'CANCELADA'OR v.estado = 'FECHADA')")
    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndDataFechamento(LocalDate var1);

    @Query(value="SELECT v FROM Venda v LEFT JOIN Caixa c ON v.caixa=c.id AND c.sincronizado = false AND c.aberto=false WHERE v.sincronizado=true AND CAST(v.dataFechamento as LocalDate)=:data AND (v.estado = 'CANCELADA'OR v.estado = 'FECHADA')")
    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndDataFechamentoIgual(LocalDate var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.sincronizado = true, v.jsonEnvio=:json,v.dataHoraEnvioScanntech=current_timestamp WHERE v.id=:id")
    public void marcarComoSincronizada(Long var1, String var2);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.erroEnvioScanntech=true, v.erroEnvioScanntechRetorno=:erro, v.jsonEnvio=:json WHERE v.id=:id")
    public void marcarComErroAoEnviar(Long var1, String var2, String var3);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.erroEnvioScanntech=true, v.erroEnvioScanntechRetorno=:erro, v.jsonEnvio=:json,v.scanntechErroReenvio=true WHERE v.id=:id")
    public void marcarComErroAoReenviar(Long var1, String var2, String var3);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.erroEnvioScanntech=true, v.erroEnvioScanntechRetorno=:erro, v.jsonEnvio=:json,v.scanntechErro400=true WHERE v.id=:id")
    public void marcarComErro400(Long var1, String var2, String var3);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.sincronizado = false WHERE v.id=:id")
    public void marcarComoNaoSincronizada(Long var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda AS v SET v.sincronizado = false,v.dataHoraEnvioScanntech=null,v.jsonEnvio=null WHERE DATE(v.dataFechamento)=:data")
    public void marcarComoNaoSincronizadaByData(LocalDate var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.sincronizado = false,v.dataHoraEnvioScanntech=null,v.jsonEnvio=null WHERE v.caixa=:id")
    public void marcarComoNaoSincronizadaByIdcaixa(Long var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.sincronizadoCancelada = true,v.jsonEnvioCancelamento=:json,v.dataHoraEnvioCancelamentoScanntech=current_timestamp WHERE v.id=:id")
    public void marcarComoSincronizadaCancelada(Long var1, String var2);

    @Transactional
    @Modifying
    @Query(value="UPDATE Venda v SET v.sincronizadoCancelada = true,v.jsonEnvioCancelamento=:json,v.dataHoraEnvioCancelamentoScanntech=current_timestamp,v.erroEnvioScanntech=false,v.scanntechErroReenvio=false, v.erroEnvioScanntechRetorno=null WHERE v.id=:id")
    public void marcarComoSincronizadaPosErro(Long var1, String var2);
}

