/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.CaixaRegistradoScanntech;
import com.softjava.motor.repository.CaixaRegistradoScanntechRepository;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaixaRegistradoScanntechService {
    private static final Logger log = LoggerFactory.getLogger(CaixaRegistradoScanntechService.class);
    private final CaixaRegistradoScanntechRepository repository;

    @Transactional
    public void salvar(CaixaRegistradoScanntech objeto) {
        log.info("SALVANDO REGISTRO");
        this.repository.save((Object)objeto);
        log.info("REGISTRO SALVA");
    }

    public List<CaixaRegistradoScanntech> findAllReenviarIsFalse() {
        return this.repository.findByReenviarIsFalse();
    }

    @Transactional
    public void marcarComoReenviar(LocalDate data) {
        log.info("Marcando registro para reenvio");
        this.repository.marcarComoReenviarByData(data);
        log.info("Registro marcado");
    }

    @Transactional
    public void marcarComoReenviar(Long id) {
        log.info("Marcando registro para reenvio");
        this.repository.marcarComoReenviarById(id);
        log.info("Registro marcado");
    }

    public CaixaRegistradoScanntechService(CaixaRegistradoScanntechRepository repository) {
        this.repository = repository;
    }
}

