/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.Caixa;
import com.softjava.motor.model.dto.CaixaDTO;
import com.softjava.motor.model.dto.CaixaFechamentoDTO;
import com.softjava.motor.repository.CaixaRepository;
import com.softjava.motor.util.DataUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaixaService {
    private static final Logger log = LoggerFactory.getLogger(CaixaService.class);
    private final CaixaRepository repository;
    private final DataUtils dataUtils;

    @Transactional
    public void salvar(Caixa objeto) {
        log.info("Persistindo registro de caixa");
        this.repository.save((Object)objeto);
        log.info("Registro de caixa persistido");
    }

    public List<CaixaDTO> findAllPendentesEnvio() {
        log.info("Buscando registros pendentes de envio");
        return this.repository.findCaixasPendenteEnvio(this.dataUtils.data());
    }

    public List<CaixaFechamentoDTO> findAllRegistrosPendentesEnvio() {
        log.info("Buscando registros pendentes de envio");
        return this.repository.findCaixasEnvio(this.dataUtils.data());
    }

    public boolean vendasComErroNoReenvioByCaixa(Integer caixa) {
        log.info("Verificando registros com erros!");
        return Optional.ofNullable(this.repository.ticketComErroReenvioByCaixa(caixa)).orElse(0L) > 0L;
    }

    @Transactional
    public void marcarComoSincronizada(Integer id, String json) {
        log.info("Marcando registro como sincronizado");
        this.repository.marcarComoSincronizada(id, json);
        log.info("Registro marcado como sincronizado");
    }

    @Transactional
    public void marcarComoErroAoEnviar(Integer id, String erro, String json) {
        log.info("Marcanco registro como erro ao enviar");
        this.repository.marcarComErroAoEnviar(id, erro, json);
        log.info("Registro marcado como erro ao enviar");
    }

    @Transactional
    public void marcarComoNaoSincronizadaPorId(Integer id) {
        log.info("Marcando registro como nao sincronizado");
        this.repository.marcarComoNaoSincronizadaPorId(id);
        log.info("Registro marcado como nao sincronizado");
    }

    @Transactional
    public void marcarComoNaoSincronizada(LocalDate date) {
        log.info("Marcanco registro como nao sincronizado");
        this.repository.marcarComoNaoSincronizadaByData(date);
        log.info("Registro marcado como nao sincronizado");
    }

    public CaixaService(CaixaRepository repository, DataUtils dataUtils) {
        this.repository = repository;
        this.dataUtils = dataUtils;
    }
}

