/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.ConfigApp;
import com.softjava.motor.util.Encryption;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileConfigService {
    private static final Logger log = LoggerFactory.getLogger(FileConfigService.class);
    private static final String FILE_PATH = "config.properties";

    public static void gravarDadosDb(ConfigApp config) {
        try {
            log.info("Gravando as configs da base de dados no arquivo..");
            Properties properties = FileConfigService.readPropertiesFile((String)"config.properties");
            properties.setProperty("database.username", Encryption.encrypt((String)config.getUsuario()));
            properties.setProperty("database.password", Encryption.encrypt((String)config.getSenha()));
            properties.setProperty("database.url", config.getUrl());
            FileConfigService.writePropertiesFile((Properties)properties, (String)"config.properties");
            log.info("Grava\u00e7\u00e3o das configs realizadas com sucesso..");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static ConfigApp lerDadosConfigDb() throws Exception {
        log.info("Lendo as configs do arquivo..");
        ConfigApp config = new ConfigApp();
        Properties properties = FileConfigService.readPropertiesFile((String)"config.properties");
        config.setUsuario(properties.getProperty("database.username", "v1QVng3N+pZd/0AEObABwg=="));
        config.setSenha(properties.getProperty("database.password", "MytKWl9FLTePkS4WGA/NpQ=="));
        config.setUrl(properties.getProperty("database.url", "127.0.0.1:5432/softjava"));
        log.info("Leitura das configs realizadas com sucesso..");
        return config;
    }

    public static void gravarConfigApp(ConfigApp config) {
        log.info("Gravando as configs no arquivo..");
        Properties properties = FileConfigService.readPropertiesFile((String)"config.properties");
        properties.setProperty("scanntecth.ativo", Optional.ofNullable(config.getScanntechAtivo()).orElse("nao"));
        properties.setProperty("scanntecth.log", Optional.ofNullable(config.getScanntechLog()).orElse("nao"));
        properties.setProperty("scanntecth.usuario", config.getScanntechUsuario());
        properties.setProperty("scanntecth.senha", config.getScanntechSenha());
        properties.setProperty("scanntecth.url_1", config.getScanntechUrl_1());
        properties.setProperty("scanntecth.url_2", config.getScanntechUrl_2());
        properties.setProperty("scanntecth.url_3", config.getScanntechUrl_3());
        properties.setProperty("scanntecth.empresa", config.getScanntechEmpresa());
        properties.setProperty("scanntecth.local", config.getScanntechLocal());
        properties.setProperty("scanntecth.intervalominutos", config.getScanntechIntervaloMinutos());
        properties.setProperty("scanntecth.horaconsultareenvio", config.getScanntechHoraConsultaReenvio());
        properties.setProperty("scanntecth.minutoconsultareenvio", config.getScanntechMinutoConsultaReenvio());
        properties.setProperty("scanntecth.minutosenvioticket", config.getScanntechMinutosEnvioTicket());
        properties.setProperty("scanntecth.horaenviofechamento", config.getScanntechHoraEnvioFechamento());
        properties.setProperty("scanntecth.datainicio", config.getScanntechDataInicio());
        FileConfigService.writePropertiesFile((Properties)properties, (String)"config.properties");
        log.info("Grava\u00e7\u00e3o das configs realizadas com sucesso..");
    }

    public static ConfigApp lerConfigApp() throws IOException, ConfigurationException {
        log.info("Lendo as configs do arquivo..");
        ConfigApp config = new ConfigApp();
        Properties properties = FileConfigService.readPropertiesFile((String)"config.properties");
        config.setScanntechAtivo(properties.getProperty("scanntecth.ativo", "nao"));
        config.setScanntechLog(properties.getProperty("scanntecth.log", "nao"));
        config.setScanntechUsuario(properties.getProperty("scanntecth.usuario", "integrador_test@softjava.com.br"));
        config.setScanntechSenha(properties.getProperty("scanntecth.senha", "integrador"));
        config.setScanntechUrl_1(properties.getProperty("scanntecth.url_1", "http://br.homo.apipdv.scanntech.com"));
        config.setScanntechUrl_2(properties.getProperty("scanntecth.url_2", "http://parceiro1.scanntech.com"));
        config.setScanntechUrl_3(properties.getProperty("scanntecth.url_3", "http://parceiro2.scanntech.com"));
        config.setScanntechEmpresa(properties.getProperty("scanntecth.empresa", "74784"));
        config.setScanntechLocal(properties.getProperty("scanntecth.local", "1"));
        config.setScanntechIntervaloMinutos(properties.getProperty("scanntecth.intervalominutos", "20"));
        config.setScanntechHoraConsultaReenvio(properties.getProperty("scanntecth.horaconsultareenvio", "14"));
        config.setScanntechMinutoConsultaReenvio(properties.getProperty("scanntecth.minutoconsultareenvio", "30"));
        config.setScanntechHoraEnvioFechamento(properties.getProperty("scanntecth.horaenviofechamento", "12"));
        config.setScanntechMinutosEnvioTicket(properties.getProperty("scanntecth.minutosenvioticket", "20"));
        config.setScanntechDataInicio(properties.getProperty("scanntecth.datainicio", "2024-04-01"));
        log.info("Leitura das configs realizadas com sucesso..");
        return config;
    }

    private static Properties readPropertiesFile(String filePath) {
        Properties properties = new Properties();
        try (FileInputStream fileInput = new FileInputStream(filePath);){
            properties.load(fileInput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static void writePropertiesFile(Properties properties, String filePath) {
        try (FileOutputStream fileOutput = new FileOutputStream(filePath);){
            properties.store(fileOutput, "Exemplo de arquivo .properties atualizado");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean logAtivo() {
        try {
            ConfigApp config = new ConfigApp();
            Properties properties = FileConfigService.readPropertiesFile((String)"config.properties");
            return "sim".equals(properties.getProperty("scanntecth.log", "nao"));
        }
        catch (Exception e) {
            return false;
        }
    }
}

