/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.Produto;
import com.softjava.motor.repository.ProdutoRepository;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProdutoService {
    private static final Logger log = LoggerFactory.getLogger(ProdutoService.class);
    private final ProdutoRepository repository;

    @Transactional
    public void salvar(Produto objeto) {
        log.info("Persistindo registro..");
        this.repository.save((Object)objeto);
        log.info("Registro persistido com sucesso..");
    }

    @Transactional
    public void ativarPromocao(Long idpromocao, String codigo, boolean l1, boolean l2, boolean l3, BigDecimal l4, BigDecimal l5, BigDecimal l6, BigDecimal l7, BigDecimal l8, boolean l9) {
        log.info("Ativando promo\u00e7\u00f5es com o id {} e c\u00f3digo {}", (Object)idpromocao, (Object)codigo);
        this.repository.ativarPromocao(idpromocao, codigo, l1, l2, l3, l4, l5, l6, l7, l8, l9);
        log.info("Promo\u00e7\u00f5es ativadas");
    }

    @Transactional
    public void desativarPromocao(Long idpromocao) {
        log.info("Desativando promo\u00e7\u00f5es com o id {}", (Object)idpromocao);
        this.repository.desativarPromocao(idpromocao);
        log.info("Promo\u00e7\u00f5es desativadas");
    }

    @Transactional
    public void desativarPromocao(List<Long> ids) {
        log.info("Desativando promo\u00e7\u00f5es.. com os ids {}", ids);
        if (ids.isEmpty()) {
            this.repository.desativarPromocoesGerais();
        } else {
            this.repository.desativarPromocoes(ids);
        }
        log.info("Promo\u00e7\u00f5es desativadas");
    }

    public ProdutoService(ProdutoRepository repository) {
        this.repository = repository;
    }
}

