/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.ScannTechPromocao;
import com.softjava.motor.repository.ScannTechPromocaoRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScannTechPromocaoService {
    private static final Logger log = LoggerFactory.getLogger(ScannTechPromocaoService.class);
    private final ScannTechPromocaoRepository repository;

    public ScannTechPromocao findTopByIdscanntech(Long idscanntech) {
        log.info("Buscando por idscanntech {}", (Object)idscanntech);
        return this.repository.findTopByIdscanntech(idscanntech);
    }

    public ScannTechPromocao findTopByIdscanntechAndCodigo(Long idscanntech, String codigo) {
        log.info("Buscando por idscanntech {} e codigo {}", (Object)idscanntech, (Object)codigo);
        return this.repository.findTopByIdscanntechAndCodigo(idscanntech, codigo);
    }

    @Transactional
    public void salvar(ScannTechPromocao objeto) {
        log.info("Gravando registro na base dados");
        this.repository.save((Object)objeto);
        log.info("Registro gravado..");
    }

    @Transactional
    public void desativarPromocoes(List<Long> ids) {
        log.info("Desativamento promo\u00e7\u00f5es");
        if (ids.isEmpty()) {
            this.repository.desativarPromocoesGerais();
        } else {
            this.repository.desativarPromocoesNaoPresentes(ids);
        }
        log.info("Promo\u00e7\u00f5es desativadas..");
    }

    public ScannTechPromocaoService(ScannTechPromocaoRepository repository) {
        this.repository = repository;
    }
}

