/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.ScannTechReenvio;
import com.softjava.motor.repository.ScannTechReenvioRepository;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScannTechReenvioService {
    private static final Logger log = LoggerFactory.getLogger(ScannTechReenvioService.class);
    private final ScannTechReenvioRepository repository;

    public ScannTechReenvio findTopByCodigo_caixa(Long codigoCaixa) {
        log.info("Buscando por codigoCaixa {}", (Object)codigoCaixa);
        return this.repository.findTopByCodigoCaixa(codigoCaixa);
    }

    public ScannTechReenvio findTopByCodigo_caixaAndData_registro(Long codigoCaixa, LocalDate dataRegistro) {
        log.info("Buscando por codigoCaixa {} e dataRegistro {}", (Object)codigoCaixa, (Object)dataRegistro);
        return this.repository.findTopByCodigoCaixaAndDataRegistro(codigoCaixa, dataRegistro);
    }

    public List<ScannTechReenvio> registrosPendentes() {
        log.info("Buscando registros pendentes de reenvio");
        return this.repository.findFirst100ByReenviadoIsFalse();
    }

    public List<ScannTechReenvio> registrosPendentesReenviado() {
        log.info("Buscando registros pendentes de reenvio para scanntech");
        return this.repository.findFirst100ByReenviadoScanntechIsFalse();
    }

    public List<ScannTechReenvio> registrosPendentesReenviadoAndPendenteConfirmardoReenvio() {
        log.info("Buscando registros pendentes de reenvio para scanntech");
        return this.repository.findFirst100ByReenviadoScanntechIsFalseAndReenviadoScanntechConfirmadoCaixaIsFalse();
    }

    @Transactional
    public void salvar(ScannTechReenvio objeto) {
        log.info("Persistindo registro");
        this.repository.save((Object)objeto);
        log.info("Registro persistido com sucesso");
    }

    @Transactional
    public void confirmarReenvio(Long id, LocalDate data, String tipo) {
        log.info("Confirmando reenvio com id {}, data {} e tipo {}", new Object[]{id, data, tipo});
        this.repository.confirmarReenvio(id, data, tipo);
    }

    @Transactional
    public void confirmarReenvio(Long id) {
        log.info("Confirmando reenvio com id {}", (Object)id);
        this.repository.confirmarReenvio(id);
    }

    @Transactional
    public void confirmarReenvioSincronizado(Long id) {
        log.info("Confirmando reenvio com id {}", (Object)id);
        this.repository.confirmarReenvioSincronizado(id);
    }

    public ScannTechReenvioService(ScannTechReenvioRepository repository) {
        this.repository = repository;
    }
}

