/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.service;

import com.softjava.motor.model.Venda;
import com.softjava.motor.repository.VendaRepository;
import com.softjava.motor.util.DataUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@PropertySource(value={"file:${user.dir}/config.properties"})
public class VendaService {
    private static final Logger log = LoggerFactory.getLogger(VendaService.class);
    private final VendaRepository repository;
    private final DataUtils dataUtils;

    @Transactional
    public void salvar(Venda objeto) {
        log.info("Persistindo registro");
        this.repository.save((Object)objeto);
        log.info("Registro persistido com sucesso");
    }

    @Transactional
    public void marcarComoSincronizada(Long id, String json) {
        log.info("Marcando registro como sincronizada");
        this.repository.marcarComoSincronizada(id, json);
        log.info("Registro marcado como sincronizada");
    }

    @Transactional
    public void marcarComoSincronizadaPosErro(Long id, String json) {
        log.info("Marcando registro como sincronizada p\u00f3s erro");
        this.repository.marcarComoSincronizadaPosErro(id, json);
        log.info("Registro marcado como sincronizada p\u00f3s erro");
    }

    @Transactional
    public void marcarComoSincronizadaCancelada(Long id, String json) {
        log.info("Marcanco registro como sincronizada cancelada id {} json {}", (Object)id, (Object)json);
        this.repository.marcarComoSincronizadaCancelada(id, json);
        log.info("Registro marcado como sincronizada cancelada");
    }

    @Transactional
    public void marcarComoNaoSincronizadaPorData(LocalDate data) {
        log.info("Marca registro como n\u00e3o sincronizada por data {}", (Object)data);
        this.repository.marcarComoNaoSincronizadaByData(data);
        log.info("Registro marcado como n\u00e3o sincronizada");
    }

    @Transactional
    public void marcarComoNaoSincronizadaPorIdcaixa(Long id) {
        log.info("MArcando registro como n\u00e3o sincronizada por idcaixa {}", (Object)id);
        this.repository.marcarComoNaoSincronizadaByIdcaixa(id);
        log.info("Registro marcado como n\u00e3o sincronizada");
    }

    @Transactional
    public void marcarComoErroAoEnviar(Long id, String erro, String json) {
        log.info("Marcando registro como erro ao enviar id {} erro {} json {}", new Object[]{id, erro, json});
        this.repository.marcarComErroAoEnviar(id, erro, json);
        log.info("Registro marcado como erro ao enviar");
    }

    @Transactional
    public void marcarComoErro400(Long id, String erro, String json) {
        log.info("Marcando registro como erro 400 ao enviar id {} erro {} json {}", new Object[]{id, erro, json});
        this.repository.marcarComErro400(id, erro, json);
        log.info("Registro marcado como erro 400 ao enviar");
    }

    @Transactional
    public void marcarComoErroAoReenviar(Long id, String erro, String json) {
        log.info("Marcando registro como erro ao reenviar id {} erro {} json {}", new Object[]{id, erro, json});
        this.repository.marcarComErroAoReenviar(id, erro, json);
        log.info("Registro marcado como erro ao reenviar");
    }

    public List<Venda> findVendasByCaixaSincronizadoIsFalse() {
        log.info("Buscando vendas por caixa sincronizado");
        return this.repository.findVendasByCaixaSincronizadoIsFalse(this.dataUtils.data());
    }

    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndAfter1Hours() {
        log.info("Buscando vendas por caixa sincronizado com limite de no minimo 1 hora apos seu fechamento");
        LocalDateTime dataHoraLimite = LocalDateTime.now().minusHours(1L);
        log.info("Data para limitar os caixas para envio: {}", (Object)dataHoraLimite);
        return this.repository.findVendasByCaixaSincronizadoIsFalseAndAfter1Hours(this.dataUtils.data(), dataHoraLimite);
    }

    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndDataFechamento(LocalDate data) {
        log.info("Buscando vendas por caixa sincronizado");
        return this.repository.findVendasByCaixaSincronizadoIsFalseAndDataFechamento(data);
    }

    public List<Venda> findVendasByCaixaSincronizadoIsFalseAndDataFechamentoIgual(LocalDate data) {
        log.info("Buscando vendas por caixa sincronizado com data de fechamento igual");
        return this.repository.findVendasByCaixaSincronizadoIsFalseAndDataFechamentoIgual(data);
    }

    public List<Venda> fechadasNaoSincronizadas() {
        log.info("Buscando vendas fechadas n\u00e3o sincronizadas");
        return this.repository.findFirst100ByEstadoAndSincronizadoIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse("FECHADA");
    }

    public List<Venda> erroAoSincronizar() {
        log.info("Buscando vendas fechadas que tiveram erros ao sincronizar");
        return this.repository.findFirst100ByErroEnvioScanntechIsTrueAndScanntechErroReenvioIsFalseAndScanntechErro400IsFalse();
    }

    public List<Venda> canceladasNaoSincronizadasComoFechadas() {
        log.info("Buscando vendas canceladas n\u00e3o sincronizadas como fechadas");
        return this.repository.findFirst100ByEstadoAndSincronizadoIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse("CANCELADA");
    }

    public List<Venda> canceladasNaoSincronizadas() {
        log.info("Buscando vendas canceladas n\u00e3o sincronizadas");
        return this.repository.findFirst100ByEstadoAndSincronizadoCanceladaIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse("CANCELADA");
    }

    public List<Venda> canceladasNaoSincronizadasCanceladas() {
        log.info("Buscando vendas canceladas n\u00e3o sincronizadas canceladas");
        return this.repository.findFirst100ByEstadoAndSincronizadoIsTrueAndSincronizadoCanceladaIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse("CANCELADA");
    }

    public List<Venda> canceladasNaoSincronizadasCanceladasCaixaAberto() {
        log.info("Buscando vendas canceladas n\u00e3o sincronizadas canceladas");
        return this.repository.findVendasCanceladaByCaixaAberto(this.dataUtils.data());
    }

    public List<Venda> fechadasOuCanceladasNaoSincronizadas() {
        log.info("Buscando vendas canceladas ou canceladas n\u00e3o sincronizadas como fechadas");
        List<String> estados = Arrays.asList("FECHADA", "CANCELADA");
        return this.repository.findFirst1000ByEstadoInAndSincronizadoIsFalseAndScanntechPromocaoIsTrueAndErroEnvioScanntechIsFalse(estados);
    }

    public Optional<Venda> findById(Long id) {
        return this.repository.findById((Object)id);
    }

    public VendaService(VendaRepository repository, DataUtils dataUtils) {
        this.repository = repository;
        this.dataUtils = dataUtils;
    }
}

