/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.task.scanntech;

import com.softjava.motor.conversor.PromocaoConversor;
import com.softjava.motor.integracao.scanntech.dto.PromotionResponse;
import com.softjava.motor.integracao.scanntech.excessoes.ScanntechExcecao;
import com.softjava.motor.integracao.scanntech.ws.ScannTechUtils;
import com.softjava.motor.model.ScannTechPromocao;
import com.softjava.motor.service.ProdutoService;
import com.softjava.motor.service.ScannTechPromocaoService;
import com.softjava.motor.util.EthernetUtil;
import com.softjava.motor.view.ViewPrincipal;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"file:${user.dir}/config.properties"})
public class ScannTechPromocaoTask {
    private static final Logger log = LoggerFactory.getLogger(ScannTechPromocaoTask.class);
    @Value(value="${scanntecth.ativo}")
    private String ativo;
    private final ScannTechPromocaoService service;
    private final ProdutoService produtoService;
    private final ScannTechUtils scannTechUtils;

    @Scheduled(cron="0 */${scanntecth.intervalominutos} * * * *")
    public void consultar() throws ScanntechExcecao {
        block7: {
            if ("sim".equals(this.ativo)) {
                log.info("Consultando promo\u00e7\u00f5es...");
                try {
                    if (EthernetUtil.conexaoGoogle()) {
                        log.info("Buscando promo\u00e7\u00f5es aceitas..");
                        PromotionResponse response = this.scannTechUtils.consultarPromocoesPorPagamento();
                        if (response != null) {
                            log.info("Convertento promo\u00e7\u00f5es..");
                            List registros = PromocaoConversor.promocoes((PromotionResponse)response);
                            ViewPrincipal.getIntance().informarDados("Consulta retornou " + Optional.ofNullable(registros).orElse(Collections.emptyList()).size() + " produtos em promo\u00e7\u00f5es aceitas!");
                            log.info("Registrando promo\u00e7\u00f5es novas");
                            registros.forEach(r -> {
                                ScannTechPromocao promocao = this.service.findTopByIdscanntechAndCodigo(r.getIdscanntech(), r.getCodigo());
                                if (promocao == null) {
                                    this.service.salvar(r);
                                } else if (!promocao.isAtiva()) {
                                    promocao.setAtiva(true);
                                    this.service.salvar(promocao);
                                }
                            });
                            log.info("Agrupando c\u00f3digos de promo\u00e7\u00f5es");
                            List ids = registros.stream().map(p -> p.getIdscanntech()).distinct().collect(Collectors.toList());
                            log.info("Desativando promo\u00e7\u00f5es ativas");
                            this.service.desativarPromocoes(Optional.ofNullable(ids).orElse(Collections.emptyList()));
                            log.info("Desativando promo\u00e7\u00f5es ativas em produtos");
                            this.produtoService.desativarPromocao(Optional.ofNullable(ids).orElse(Collections.emptyList()));
                            log.info("Ativando promo\u00e7\u00f5es novas em produtos");
                            registros.stream().forEach(r -> {
                                boolean l1 = "LLEVA_PAGA".equals(r.getTipo());
                                boolean l2 = "PRECIO_FIJO".equals(r.getTipo());
                                boolean l3 = "DESCUENTO_VARIABLE".equals(r.getTipo());
                                BigDecimal l4 = r.getPreco();
                                BigDecimal l5 = r.getQuantidade();
                                BigDecimal l6 = r.getPaga();
                                BigDecimal l7 = r.getDesconto();
                                BigDecimal l8 = new BigDecimal(Optional.ofNullable(r.getLimite_promocacao_por_ticket()).orElse(0L));
                                this.produtoService.ativarPromocao(r.getIdscanntech(), r.getCodigo(), l1, l2, l3, l4, l5, l6, l7, l8, r.isPorPagamento());
                            });
                        }
                        break block7;
                    }
                    log.info("Sem conex\u00e3o com internet");
                    ViewPrincipal.getIntance().informarDados("Sem comunica\u00e7\u00e3o com internet");
                }
                catch (CancellationException ex) {
                    log.error("Busca reiniciada pelo usu\u00e1rio!", (Throwable)ex);
                }
                catch (Exception e) {
                    ViewPrincipal.getIntance().informarDados("Erro : " + e.getMessage());
                    log.error("Erro : " + e.getMessage());
                    log.error("Busca reiniciada pelo usu\u00e1rio!", (Throwable)e);
                }
            } else {
                ViewPrincipal.getIntance().txtTituloLog.setText("Logs | Tarefas Autom\u00e1ticas desabilitadas..");
            }
        }
    }

    public ScannTechPromocaoTask(ScannTechPromocaoService service, ProdutoService produtoService, ScannTechUtils scannTechUtils) {
        this.service = service;
        this.produtoService = produtoService;
        this.scannTechUtils = scannTechUtils;
    }
}

