/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.task.scanntech;

import com.softjava.motor.integracao.scanntech.excessoes.ScanntechExcecao;
import com.softjava.motor.integracao.scanntech.ws.ScannTechUtils;
import com.softjava.motor.model.ScannTechReenvio;
import com.softjava.motor.service.CaixaService;
import com.softjava.motor.service.ScannTechReenvioService;
import com.softjava.motor.service.VendaService;
import com.softjava.motor.view.ViewPrincipal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"file:${user.dir}/config.properties"})
public class ScannTechReenvioTask {
    private static final Logger log = LoggerFactory.getLogger(ScannTechReenvioTask.class);
    @Value(value="${scanntecth.ativo}")
    private String ativo;
    private final ScannTechReenvioService service;
    private final CaixaService caixaService;
    private final VendaService vendaService;
    private final ScannTechUtils scannTechUtils;

    @Scheduled(cron="0 ${scanntecth.minutoconsultareenvio} ${scanntecth.horaconsultareenvio} * * *")
    public void consultar() throws ScanntechExcecao {
        if ("sim".equals(this.ativo)) {
            try {
                log.info("Buscando reenvios pendentes de registros no banco");
                List pendentes = this.service.registrosPendentes();
                pendentes.forEach(r -> {
                    log.info("Verificando reenvio");
                    if ("MOVIMIENTOS".equals(r.getTipo())) {
                        log.info("Reenvio de movimentos");
                        if (r.getCodigoCaixa() != null && r.getCodigoCaixa() == 0) {
                            log.info("Marcando registros como n\u00e3o sincronizado");
                            this.vendaService.marcarComoNaoSincronizadaPorData(r.getDataRegistro());
                        } else {
                            log.info("Marcando registros como n\u00e3o sincronizados");
                            this.vendaService.marcarComoNaoSincronizadaPorIdcaixa(r.getId());
                        }
                    } else if ("CIERRES_DIARIOS".equals(r.getTipo())) {
                        log.info("Reenvio de caixa");
                        if (r.getCodigoCaixa() != null) {
                            log.info("Marcando registros como n\u00e3o sincronizados");
                            this.caixaService.marcarComoNaoSincronizadaPorId(r.getCodigoCaixa());
                        }
                    }
                    log.info("Marcando reenvio como registrado");
                    this.service.confirmarReenvio(r.getId());
                });
                log.info("Consultando novos reenvios");
                ArrayList registros = new ArrayList();
                ViewPrincipal.getIntance().informarDados("Consultando reenvio de movimentos");
                List responseMovimento = this.scannTechUtils.consultaReenvioMovimento();
                if (responseMovimento != null) {
                    responseMovimento.forEach(r -> {
                        ScannTechReenvio obj = new ScannTechReenvio();
                        obj.converter(r);
                        registros.add(obj);
                        registros.add(obj);
                    });
                }
                ViewPrincipal.getIntance().informarDados("Consultando reenvio de fechamentos");
                List responseFechamento = this.scannTechUtils.consultaReenvioFechamento();
                if (responseFechamento != null) {
                    responseFechamento.forEach(r -> {
                        ScannTechReenvio obj = new ScannTechReenvio();
                        obj.converter(r);
                        registros.add(obj);
                        registros.add(obj);
                    });
                }
                registros.forEach(r -> this.service.salvar(r));
                ViewPrincipal.getIntance().informarDados("Localizado(s) " + registros.size() + " reenvios..");
            }
            catch (CancellationException ex) {
                log.info("Busca reiniciada pelo usu\u00e1rio!");
            }
            catch (Exception e) {
                log.error("Erro : " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            ViewPrincipal.getIntance().txtTituloLog.setText("Logs | Tarefas Autom\u00e1ticas desabilitadas..");
        }
    }

    public ScannTechReenvioTask(ScannTechReenvioService service, CaixaService caixaService, VendaService vendaService, ScannTechUtils scannTechUtils) {
        this.service = service;
        this.caixaService = caixaService;
        this.vendaService = vendaService;
        this.scannTechUtils = scannTechUtils;
    }
}

