/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.task.scanntech;

import com.softjava.motor.integracao.scanntech.excessoes.ScanntechExcecao;
import com.softjava.motor.integracao.scanntech.ws.ScannTechUtils;
import com.softjava.motor.model.ScannTechReenvio;
import com.softjava.motor.model.Venda;
import com.softjava.motor.model.dto.VendaDTO;
import com.softjava.motor.service.CaixaService;
import com.softjava.motor.service.ScannTechReenvioService;
import com.softjava.motor.service.VendaService;
import com.softjava.motor.task.scanntech.util.BoxUtilsTask;
import com.softjava.motor.task.scanntech.util.TicketUtilsTask;
import com.softjava.motor.util.EthernetUtil;
import com.softjava.motor.view.ViewPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"file:${user.dir}/config.properties"})
public class ScannTechTicketTask {
    private static final Logger log = LoggerFactory.getLogger(ScannTechTicketTask.class);
    @Value(value="${scanntecth.ativo}")
    private String ativo;
    private final VendaService service;
    private final CaixaService caixaService;
    private final ScannTechReenvioService scannTechReenvioService;
    private final ScannTechUtils scannTechUtils;

    @Scheduled(cron="0 */${scanntecth.minutosenvioticket} * * * *")
    public void consultar() throws ScanntechExcecao {
        block10: {
            if ("sim".equals(this.ativo)) {
                log.info("Consultando vendas...");
                ViewPrincipal.getIntance().informarDados("Consultando vendas...");
                try {
                    if (EthernetUtil.conexaoGoogle()) {
                        log.info("Buscando Vendas com problemas de sincroniza\u00e7\u00e3o durante envio..");
                        ViewPrincipal.getIntance().informarDados("Buscando Vendas com problemas de sincroniza\u00e7\u00e3o durante envio..");
                        List vendasComErroAoSincronizar = this.service.erroAoSincronizar();
                        log.info("Foram localizada(s) " + vendasComErroAoSincronizar.size() + " vendas com erro ao sincronizar");
                        ViewPrincipal.getIntance().informarDados("Foram localizada(s) " + vendasComErroAoSincronizar.size() + " vendas com erro ao sincronizar");
                        vendasComErroAoSincronizar.forEach(v -> {
                            log.info("Enviando venda com erro ao sincronizar c\u00f3digo {}", (Object)v.getId());
                            TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)v);
                        });
                        log.info("Buscando Vendas fechadas pendentes de envio..");
                        ViewPrincipal.getIntance().informarDados("Buscando vendas pendentes de envio..");
                        List vendasFechadasPendentes = this.service.fechadasNaoSincronizadas();
                        log.info("Foram localizada(s) " + vendasFechadasPendentes.size() + " vendas pendentes");
                        ViewPrincipal.getIntance().informarDados("Foram localizada(s) " + vendasFechadasPendentes.size() + " vendas pendentes");
                        vendasFechadasPendentes.forEach(v -> TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)v));
                        log.info("Buscando Vendas canceladas pendentes de envio..");
                        List vendasCanceladasPendentes = this.service.canceladasNaoSincronizadasCanceladasCaixaAberto();
                        log.info("Foram localizada(s) " + vendasCanceladasPendentes.size() + " vendas canceladas pendentes");
                        ViewPrincipal.getIntance().informarDados("Foram localizada(s) " + vendasCanceladasPendentes.size() + " vendas canceladas pendentes");
                        vendasCanceladasPendentes.forEach(v -> TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)v));
                        log.info("Buscando Vendas fechadas ou canceladas pendentes de envio..");
                        List vendasFechadasOuCanceladasPendentes = this.service.fechadasOuCanceladasNaoSincronizadas();
                        log.info("Foram localizada(s) " + vendasFechadasOuCanceladasPendentes.size() + " vendas fechadas ou canceladas pendentes");
                        ViewPrincipal.getIntance().informarDados("Foram localizada(s) " + vendasFechadasOuCanceladasPendentes.size() + " vendas fechadas ou canceladas pendentes");
                        vendasFechadasOuCanceladasPendentes.forEach(v -> {
                            if ("CANCELADA".equals(v.getEstado()) && !v.isSincronizado()) {
                                log.info("Enviando venda cancelada com erro ao sincronizar c\u00f3digo {}", (Object)v.getId());
                                TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)v, (boolean)false);
                                Optional v2 = this.service.findById(v.getId());
                                if (v2.isPresent()) {
                                    log.info("Enviando venda fechada com erro ao sincronizar c\u00f3digo {}", (Object)((Venda)v2.get()).getId());
                                    TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)((Venda)v2.get()));
                                } else {
                                    log.warn("Venda n\u00e3o encontrada para reenvio");
                                }
                            } else {
                                log.info("Enviando venda fechada com erro ao sincronizar c\u00f3digo {}", (Object)v.getId());
                                TicketUtilsTask.send((ScannTechUtils)this.scannTechUtils, (VendaService)this.service, (Venda)v);
                            }
                        });
                        log.info("Buscando caixas pendentes de envio..");
                        ViewPrincipal.getIntance().informarDados("Buscando caixas pendentes de envio..");
                        log.info("Buscando caixas pendentes de envio..");
                        List caixasFechadosPendentes = this.service.findVendasByCaixaSincronizadoIsFalseAndAfter1Hours().stream().map(Venda::toDTO).collect(Collectors.toList());
                        ViewPrincipal.getIntance().informarDados("Agrupando vendas por caixa e data");
                        log.info("Agrupando vendas por caixa e data");
                        List vendasAgrupadasPorCaixaData = new ArrayList(caixasFechadosPendentes.stream().collect(Collectors.toMap(mov -> Arrays.asList(mov.getCodigo(), mov.getDataVenda()), Function.identity(), VendaDTO::aggregation)).values()).stream().sorted(Comparator.comparing(VendaDTO::getDataVenda)).collect(Collectors.toList());
                        log.info("Criando map com caixa e vendas agrupadas");
                        Map caixaComVendas = vendasAgrupadasPorCaixaData.stream().collect(Collectors.groupingBy(VendaDTO::getCodigo, Collectors.toList()));
                        log.info("Enviando caixas para scanntech");
                        for (Map.Entry caixa : caixaComVendas.entrySet()) {
                            log.info("Caixa : " + caixa.getKey());
                            List listaDeVendas = caixa.getValue();
                            for (VendaDTO vendaDTO : listaDeVendas) {
                                ViewPrincipal.getIntance().informarDados("Enviando caixa : " + vendaDTO.getCodigo());
                                log.info("Enviando caixa : " + vendaDTO.getCodigo());
                                BoxUtilsTask.send((ScannTechUtils)this.scannTechUtils, (CaixaService)this.caixaService, (VendaDTO)vendaDTO);
                            }
                            log.info("Verificando se todas as vendas foram sincronizadas");
                            boolean sincronizadas = listaDeVendas.stream().allMatch(VendaDTO::isSincronizada);
                            log.info("Todas vendas do caixa foram sincronizadas : " + sincronizadas);
                            if (!sincronizadas) continue;
                            log.info("Marcando caixa como sincronizada");
                            this.caixaService.marcarComoSincronizada(caixa.getKey(), "");
                        }
                        log.info("Buscando caixas pendentes de reenvio..");
                        ViewPrincipal.getIntance().informarDados("Buscando caixas pendentes de reenvio..");
                        List<ScannTechReenvio> caixasScannTechReenviosPendentes = Optional.ofNullable(this.scannTechReenvioService.registrosPendentesReenviadoAndPendenteConfirmardoReenvio()).orElse(Collections.emptyList());
                        log.info("Foram localizados {} caixas pendentes de reenvio..", (Object)caixasScannTechReenviosPendentes.size());
                        if (caixasScannTechReenviosPendentes.isEmpty()) {
                            ViewPrincipal.getIntance().informarDados("N\u00e3o existem caixas pendentes de reenvio..");
                        } else {
                            caixasScannTechReenviosPendentes.forEach(r -> {
                                log.info("Buscando movimentos do dia {} para reenvio baseado no caixa {}", (Object)r.getDataRegistro(), (Object)r.getCodigoCaixa());
                                List caixasFechadosPendentesReenvio = this.service.findVendasByCaixaSincronizadoIsFalseAndDataFechamentoIgual(r.getDataRegistro()).stream().map(Venda::toDTO).collect(Collectors.toList());
                                ViewPrincipal.getIntance().informarDados("Agrupando vendas por caixa e data");
                                log.info("Agrupando vendas por caixa e data para reenvio");
                                List registrosReenvioCaixaAgrupado = new ArrayList(caixasFechadosPendentesReenvio.stream().collect(Collectors.toMap(mov -> Arrays.asList(mov.getCodigo(), mov.getDataVenda()), Function.identity(), VendaDTO::aggregation)).values()).stream().sorted(Comparator.comparing(VendaDTO::getDataVenda)).collect(Collectors.toList());
                                log.info("Criando map com caixa e vendas agrupadas para reenvio");
                                Map caixaReenvioComVendas = registrosReenvioCaixaAgrupado.stream().collect(Collectors.groupingBy(VendaDTO::getCodigo, Collectors.toList()));
                                log.info("Enviando caixas para scanntech para reenvio");
                                for (Map.Entry caixa : caixaReenvioComVendas.entrySet()) {
                                    log.info(caixa.getKey() + " : " + caixa.getValue().size() + " vendas");
                                    log.info("Caixa : " + caixa.getKey());
                                    List listaDeVendas = caixa.getValue();
                                    for (VendaDTO vendaDTO : listaDeVendas) {
                                        ViewPrincipal.getIntance().informarDados("Enviando caixa para reenvio : " + vendaDTO.getCodigo());
                                        log.info("Enviando caixa  para reenvio : " + vendaDTO.getCodigo());
                                        BoxUtilsTask.send((ScannTechUtils)this.scannTechUtils, (CaixaService)this.caixaService, (VendaDTO)vendaDTO);
                                        log.info("Confirmando reenvio com sucesso " + vendaDTO.getCodigo());
                                        this.scannTechReenvioService.confirmarReenvioSincronizado(r.getId());
                                    }
                                }
                            });
                        }
                        break block10;
                    }
                    log.info("Sem conex\u00e3o com internet");
                    ViewPrincipal.getIntance().informarDados("Sem comunica\u00e7\u00e3o com internet");
                }
                catch (CancellationException ex) {
                    log.info("Busca reiniciada pelo usu\u00e1rio!");
                    ViewPrincipal.getIntance().informarDados("Busca reiniciada pelo usu\u00e1rio!");
                }
                catch (Exception e) {
                    ViewPrincipal.getIntance().informarDados("Erro : " + e.getMessage());
                    log.error("Erro : ", (Throwable)e);
                }
            } else {
                log.info("Tarefas Autom\u00e1ticas desabilitadas..");
                ViewPrincipal.getIntance().txtTituloLog.setText("Logs | Tarefas Autom\u00e1ticas desabilitadas..");
            }
        }
    }

    public ScannTechTicketTask(VendaService service, CaixaService caixaService, ScannTechReenvioService scannTechReenvioService, ScannTechUtils scannTechUtils) {
        this.service = service;
        this.caixaService = caixaService;
        this.scannTechReenvioService = scannTechReenvioService;
        this.scannTechUtils = scannTechUtils;
    }
}

