/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.task.scanntech.util;

import com.softjava.motor.integracao.scanntech.dto.CaixaScanntech;
import com.softjava.motor.integracao.scanntech.ws.ScannTechUtils;
import com.softjava.motor.model.dto.VendaDTO;
import com.softjava.motor.service.CaixaService;
import com.softjava.motor.util.genson.GensonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BoxUtilsTask {
    private static final Logger log = LoggerFactory.getLogger(BoxUtilsTask.class);

    public static void send(ScannTechUtils scannTechUtils, CaixaService caixaService, VendaDTO vendaDTO) {
        String json = "";
        try {
            log.info("Convertendo DTO para CaixaScanntech");
            CaixaScanntech dto = new CaixaScanntech();
            dto.converter(vendaDTO);
            json = BoxUtilsTask.converteCaixa((CaixaScanntech)dto);
            log.info("Json Caixa {}", (Object)json);
            scannTechUtils.enviarCaixa(vendaDTO.getCodigo(), dto);
            log.info("Caixa enviado com sucesso");
            vendaDTO.setSincronizada(true);
        }
        catch (Exception e) {
            log.error("Erro ao enviar caixa : ", (Throwable)e);
            vendaDTO.setSincronizada(false);
            log.info("Marcando caixa como erro ao enviar");
            caixaService.marcarComoErroAoEnviar(vendaDTO.getCodigo(), e.getMessage(), json);
            log.error("Erro ao enviar caixa : " + e.getMessage());
        }
    }

    private static String converteCaixa(CaixaScanntech dto) {
        log.info("Criando JSON do caixa para envio");
        GensonUtil dtoGsonUtil = new GensonUtil();
        String jsonComId = dtoGsonUtil.serialize((Object)dto);
        log.info("Caixa convertido em JSON : " + jsonComId);
        return jsonComId;
    }
}

