/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.task.scanntech.util;

import com.softjava.motor.integracao.scanntech.dto.TicketScanntech;
import com.softjava.motor.integracao.scanntech.ws.ScannTechUtils;
import com.softjava.motor.model.Venda;
import com.softjava.motor.service.VendaService;
import com.softjava.motor.util.genson.GensonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TicketUtilsTask {
    private static final Logger log = LoggerFactory.getLogger(TicketUtilsTask.class);

    public static void send(ScannTechUtils scannTechUtils, VendaService service, Venda venda) {
        TicketUtilsTask.send((ScannTechUtils)scannTechUtils, (VendaService)service, (Venda)venda, (boolean)true);
    }

    public static void send(ScannTechUtils scannTechUtils, VendaService service, Venda venda, boolean validarEstado) {
        String json = "";
        try {
            log.info("Convertendo DTO para TicketScanntech");
            TicketScanntech dto = new TicketScanntech();
            dto.converter(venda, validarEstado);
            json = TicketUtilsTask.converterTicket((TicketScanntech)dto);
            log.info("Enviando venda para scanntech");
            scannTechUtils.enviarVenda(venda.getCaixa().getNumero(), dto);
            if (validarEstado && dto.isCancelacion()) {
                log.info("Venda cancelada enviada com sucesso");
                service.marcarComoSincronizadaCancelada(venda.getId(), json);
            } else {
                log.info("Venda enviada com sucesso");
                if (venda.isErroEnvioScanntech()) {
                    log.info("Marcando venda como sincronizada ap\u00f3s erro");
                    service.marcarComoSincronizadaPosErro(venda.getId(), json);
                } else {
                    log.info("Marcando venda como sincronizada");
                    service.marcarComoSincronizada(venda.getId(), json);
                }
            }
        }
        catch (Exception e) {
            if (venda.isErroEnvioScanntech()) {
                if (!e.getMessage().contains("401")) {
                    log.error("Erro ao reenviar venda : ", (Throwable)e);
                    service.marcarComoErroAoReenviar(venda.getId(), e.getMessage(), json);
                }
            }
            if (!e.getMessage().contains("400")) {
                log.error("Erro ao enviar venda : ", (Throwable)e);
                service.marcarComoErroAoEnviar(venda.getId(), e.getMessage(), json);
            }
            log.error("Erro 400 ao enviar venda : ", (Throwable)e);
            service.marcarComoErro400(venda.getId(), e.getMessage(), json);
        }
    }

    private static String converterTicket(TicketScanntech dto) {
        log.info("Convertendo DTO do Ticket para JSON");
        GensonUtil dtoGsonUtil = new GensonUtil();
        String jsonComId = dtoGsonUtil.serialize((Object)dto);
        log.info("Ticket convertido em JSON : " + jsonComId);
        return jsonComId;
    }
}

