/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util;

import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"file:${user.dir}/config.properties"})
public class DataUtils {
    private static final Logger log = LoggerFactory.getLogger(DataUtils.class);
    @Value(value="${scanntecth.datainicio}")
    private String datainicio;

    public LocalDate data() {
        try {
            log.info("Data de inicio: " + this.datainicio);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
            LocalDate localDate = LocalDate.parse(this.datainicio, formatter);
            return localDate;
        }
        catch (Exception e) {
            return LocalDate.of(2190, Month.JANUARY, 1);
        }
    }
}

