/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util;

import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetUtil {
    private static final Logger log = LoggerFactory.getLogger(EthernetUtil.class);

    public static boolean conexaoGoogle() {
        try {
            log.info("Verificando conex\u00e3o com o Google");
            URL conexao = new URL("https://google.com");
            URLConnection conn = conexao.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            httpConn.connect();
            int x = httpConn.getResponseCode();
            return x == 200;
        }
        catch (Exception ex) {
            log.error("Erro ao verificar conex\u00e3o com o Google", (Throwable)ex);
            return false;
        }
    }

    public static boolean ping(String host) {
        try {
            log.info("Realizando ping no host: " + host);
            if (host != null) {
                host = host.toLowerCase();
                host = host.replace("http://", "");
                host = host.replace("https://", "");
            }
            InetAddress inetAddress = InetAddress.getByName(host);
            boolean isReachable = inetAddress.isReachable(5000);
            return isReachable;
        }
        catch (UnknownHostException e) {
            log.error("Host desconhecido: " + host, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error("Erro ao realizar ping: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

