/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util;

import com.softjava.motor.util.GTINUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GTINUtil {
    private static final Logger log = LoggerFactory.getLogger(GTINUtil.class);
    private static final String SEM_GTIN = "SEM GTIN";

    public static Boolean isGTIN(int GTIN) {
        log.info("Validando GTIN: " + GTIN);
        return GTIN == 8 || GTIN == 12 || GTIN == 13 || GTIN == 14;
    }

    public static Boolean isGTIN(String barras) {
        log.info("Validando GTIN: " + barras);
        return barras != null && barras.replaceAll("\\D", "").length() >= 8 && barras.replaceAll("\\D", "").length() <= 14 && GTINUtil.validaPrefixos((String)barras);
    }

    public static Boolean isValido(String barras) {
        log.info("Validando GTIN: " + barras);
        String gtin = GTINUtil.validar((String)barras);
        return !"SEM GTIN".equals(gtin);
    }

    public static String validar(String barras) {
        log.info("Validando GTIN: " + barras);
        if (!GTINUtil.isGTIN((String)barras).booleanValue()) {
            return "SEM GTIN";
        }
        return GTINUtil.validar((String)barras, (GTINEnum)GTINEnum.get((int)barras.length()));
    }

    public static String validar(String barras, GTINEnum gtin) {
        log.info("Validando GTIN: " + barras + " - " + gtin);
        if (GTINUtil.isGTIN((String)barras).booleanValue() && GTINUtil.isGTIN((int)gtin.getCodigo()).booleanValue()) {
            switch (1.$SwitchMap$com$softjava$motor$util$GTINUtil$GTINEnum[gtin.ordinal()]) {
                case 1: {
                    return GTINUtil.validaGTIN8((String)barras);
                }
                case 2: {
                    return GTINUtil.validaGTIN12((String)barras);
                }
                case 3: {
                    return GTINUtil.validaGTIN13((String)barras);
                }
                case 4: {
                    return GTINUtil.validaGTIN14((String)barras);
                }
            }
            return "SEM GTIN";
        }
        return "SEM GTIN";
    }

    public static String validaGTIN8(String barras) {
        log.info("Validando GTIN8: " + barras);
        return GTINUtil.calculaIndices((String)barras, Arrays.asList(0, 2, 4, 6));
    }

    public static String validaGTIN12(String barras) {
        log.info("Validando GTIN12: " + barras);
        return GTINUtil.calculaIndices((String)barras, Arrays.asList(0, 2, 4, 6, 8, 10));
    }

    public static String validaGTIN13(String barras) {
        log.info("Validando GTIN13: " + barras);
        return GTINUtil.calculaIndices((String)barras, Arrays.asList(1, 3, 5, 7, 9, 11));
    }

    public static String validaGTIN14(String barras) {
        log.info("Validando GTIN14: " + barras);
        return GTINUtil.calculaIndices((String)barras, Arrays.asList(0, 2, 4, 6, 8, 10, 12));
    }

    private static String calculaIndices(String barras, List<Integer> indices) {
        log.info("Calculando indices: " + barras + " - " + indices);
        List barrasArray = Arrays.asList(barras.split("")).stream().map(Integer::valueOf).collect(Collectors.toList());
        AtomicInteger soma = new AtomicInteger(0);
        IntStream.range(0, barrasArray.size() - 1).forEach(i -> {
            int n = (Integer)barrasArray.get(i);
            if (indices.contains(i)) {
                n *= 3;
            }
            soma.addAndGet(n);
        });
        int multiplo = GTINUtil.obterMultiploDeDez((int)soma.get());
        int resultado = multiplo - soma.get();
        boolean isValido = resultado == (Integer)barrasArray.get(barrasArray.size() - 1);
        return isValido ? barras : "SEM GTIN";
    }

    private static int obterMultiploDeDez(int soma) {
        log.info("Obtendo multiplo de dez: " + soma);
        return soma % 10 == 0 ? soma : soma - soma % 10 + 10;
    }

    public static boolean validaPrefixos(String barras) {
        log.info("Validando prefixos: " + barras);
        return Arrays.stream(GS1Prefixo.values()).anyMatch(gs1 -> GTINUtil.validaPrefixo((GS1Prefixo)gs1, (String)barras));
    }

    public static boolean validaPrefixo(GS1Prefixo gs1, String barras) {
        log.info("Validando prefixo: " + gs1 + " - " + barras);
        return Pattern.compile(gs1.getPrefixos()).matcher(barras).find();
    }
}

