/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextoUtils {
    public static final int NOT_FOUND = -1;

    public static String removerAcentos(String src) {
        if (StringUtils.isBlank((CharSequence)src)) {
            return src;
        }
        src = src.replace("&amp;", "E").replace("&", "E");
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String retirarAcentos(String s, boolean removeEComecial) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return s;
        }
        if (removeEComecial) {
            s = s.replace("&amp;", "E");
            s = s.replace("&", "E");
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return s;
    }

    public static String formatarNumero(Long numero) {
        return NumberFormat.getInstance().format(numero);
    }

    public static String formatarNumero(Double numero) {
        return NumberFormat.getInstance().format(numero);
    }

    public static String formatarNumero(BigDecimal numero, Integer minimumMaximumFractionDigits) {
        if (minimumMaximumFractionDigits != null) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(minimumMaximumFractionDigits);
            numberFormat.setMinimumFractionDigits(minimumMaximumFractionDigits);
            String format = numberFormat.format(numero);
            return format;
        }
        String format = NumberFormat.getInstance().format(numero);
        return format;
    }

    public static String formatarNumero(String numero, Integer MinimumMaximumFractionDigits, Locale locale, boolean removePonto) {
        String retorno;
        if (!StringUtils.isNumeric((CharSequence)TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete((String)numero))) {
            return numero;
        }
        BigDecimal bigDecimal = new BigDecimal(numero);
        if (MinimumMaximumFractionDigits != null) {
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            numberFormat.setMaximumFractionDigits(MinimumMaximumFractionDigits);
            numberFormat.setMinimumFractionDigits(MinimumMaximumFractionDigits);
            retorno = numberFormat.format(bigDecimal);
        } else {
            retorno = NumberFormat.getInstance(locale).format(bigDecimal);
        }
        if (StringUtils.isNotBlank((CharSequence)retorno)) {
            retorno = retorno.replace(",", "");
        }
        return retorno;
    }

    public static String formatarValor(String valor) {
        try {
            Double aDouble = Double.valueOf(valor);
            String valorFormatado = NumberFormat.getCurrencyInstance().format(aDouble);
            return valorFormatado;
        }
        catch (NumberFormatException e) {
            return valor;
        }
    }

    public static String formatarValor(Double valor) {
        String valorFormatado = NumberFormat.getCurrencyInstance().format(valor);
        return valorFormatado;
    }

    public static String formatarValor(BigDecimal valor) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        String valorFormatado = NumberFormat.getCurrencyInstance().format(valor);
        return valorFormatado;
    }

    public static String formatarValorSemSimboloMoeda(BigDecimal valor) {
        String formatarValor = TextoUtils.formatarValor((BigDecimal)valor);
        formatarValor = formatarValor.replace("R$ ", "");
        return formatarValor;
    }

    public static String formatarPorcentagem(BigDecimal valor, Integer digitos) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(digitos);
        BigDecimal valorDividido = valor.setScale(4, RoundingMode.HALF_EVEN).divide(BigDecimal.valueOf(100.0).setScale(4, RoundingMode.HALF_EVEN), RoundingMode.HALF_EVEN);
        String valorFormatado = percentFormat.format(valorDividido);
        return valorFormatado;
    }

    public static String retornaSomenteNumeros(String str) {
        if (str != null) {
            return str.replaceAll("[^0123456789]", "");
        }
        return "";
    }

    public static String removeEspacos(String texto) {
        return StringUtils.isNotBlank((CharSequence)texto) ? texto.replace(" ", "") : texto;
    }

    public static String trocaEspacosPorUndeline(String texto) {
        return texto.replace(" ", "_");
    }

    public static String trocaEspacosPorHifem(String texto) {
        return texto.replace(" ", "-");
    }

    public static String adicionaZeroEsquerda(String texto, Integer tamanhoTotal) {
        String leftPad = StringUtils.leftPad((String)texto, (int)tamanhoTotal, (String)"0");
        return leftPad;
    }

    public static String ajustaEspacos(String texto) {
        if (StringUtils.isBlank((CharSequence)texto)) {
            return texto;
        }
        String textoTratado = texto.replaceAll("\\s+", " ").replaceAll("\\s+$", "").replaceAll("^\\s+", "");
        return textoTratado;
    }

    public static String removePontoBarraUnderlineTracoParenteseChaveCochete(String texto) {
        if (StringUtils.isBlank((CharSequence)texto)) {
            return texto;
        }
        return texto.replace(".", "").replace("/", "").replace("\\", "").replace("-", "").replace("_", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "");
    }

    public static String removeTravessao(String texto) {
        if (StringUtils.isBlank((CharSequence)texto)) {
            return texto;
        }
        return texto.replace("\u2013", "");
    }

    public static String removeAlgunsCaracteresEspeciais(String texto) {
        if (StringUtils.isBlank((CharSequence)texto)) {
            return texto;
        }
        texto = TextoUtils.removerAcentos((String)texto);
        return texto.replace("\\", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace(";", "").replace("+", "").replace("!", "").replace("@", "").replace("#", "").replace("$", "").replace("%", "").replace("\u00a8", "").replace("&", "").replace("*", "").replace("=", "").replace("'", "").replace("\"", "");
    }

    public static String removeTodosCaracteresEspeciais(String texto) {
        if (StringUtils.isBlank((CharSequence)texto)) {
            return texto;
        }
        texto = TextoUtils.removerAcentos((String)texto);
        return texto.replace(".", "").replace(",", "").replace("/", "").replace("\\", "").replace("-", "").replace("_", "").replace("(", "").replace(")", "").replace("{", "").replace("}", "").replace("[", "").replace("]", "").replace("+", "").replace("!", "").replace("@", "").replace("#", "").replace("$", "").replace("%", "").replace("\u00a8", "").replace("&", "").replace("*", "").replace("=", "").replace("'", "").replace("\"", "");
    }

    public static String ajustaLimiteCaracterToUpperCaseTrim(String campo, int campoInicio, int campoFinal) {
        String retorno = null;
        if (StringUtils.isNotBlank((CharSequence)campo)) {
            if (campo.length() > campoFinal) {
                retorno = campo.substring(campoInicio, campoFinal);
            } else if (campo.length() < campoFinal && campo.length() > campoInicio) {
                retorno = campo.substring(campoInicio, campo.length());
            } else {
                campo = StringUtils.rightPad((String)campo, (int)campoFinal, (String)" ");
                retorno = campo.substring(campoInicio, campoFinal);
            }
            retorno = retorno.toUpperCase().trim();
        }
        return retorno;
    }

    public static String ajustaCaracterToLowerCaseTrim(String campo) {
        if (StringUtils.isNotBlank((CharSequence)campo)) {
            return campo.toLowerCase().trim();
        }
        return null;
    }

    public static String ajustaCaracterToUpperCaseTrim(String campo) {
        if (StringUtils.isNotBlank((CharSequence)campo)) {
            return campo.toUpperCase().trim();
        }
        return null;
    }

    public static String ajustaLimiteCaracter(String texto, int tamanhoMaximo) {
        String left = StringUtils.left((String)texto, (int)tamanhoMaximo);
        return left;
    }

    public static String ajustaLimiteCaracterToUpperCaseTrim(String texto, int tamanhoMaximo) {
        String left = StringUtils.left((String)texto, (int)tamanhoMaximo);
        if (StringUtils.isNotBlank((CharSequence)left)) {
            return left.toUpperCase().trim();
        }
        return left;
    }

    public static boolean validarPlaca(String placa) {
        boolean placaValida = true;
        if (placa.length() > 0) {
            if (placa.length() < 7) {
                placaValida = false;
            } else if (!placa.matches("[a-zA-Z]{3}[0-9a-zA-Z]{4}")) {
                placaValida = false;
            }
        }
        return placaValida;
    }

    public static String retornaCnpjChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)6, (int)20);
        return substring;
    }

    public static String retornaModChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)20, (int)22);
        return substring;
    }

    public static String retornaNnfChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)25, (int)34);
        return substring;
    }

    public static String retornaSerieChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)22, (int)25);
        return substring;
    }

    public static String retornaNumeroChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)25, (int)34);
        return substring;
    }

    public static String retornaTpEmisChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)34, (int)35);
        return substring;
    }

    public static String retornaMesChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)4, (int)6);
        return substring;
    }

    public static String retornaAnoChaveNf(String chave) {
        String substring = StringUtils.substring((String)chave, (int)2, (int)4);
        return substring;
    }

    public static boolean isChaveNf(String chave) {
        if (StringUtils.isBlank((CharSequence)chave)) {
            return false;
        }
        if (!StringUtils.isNumeric((CharSequence)chave)) {
            return false;
        }
        return chave.length() == 44;
    }

    private static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "" + "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String retornaDdd(String telefone) {
        telefone = TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete((String)telefone);
        if (StringUtils.isBlank((CharSequence)(telefone = TextoUtils.removeEspacos((String)telefone))) || !StringUtils.isNumeric((CharSequence)telefone)) {
            return null;
        }
        if (telefone.length() == 8 || telefone.length() == 9) {
            telefone = "00".concat(telefone);
        }
        return telefone.length() >= 2 ? telefone.substring(0, 2) : telefone;
    }

    public static String retornaNumeroSemDdd(String telefone) {
        telefone = TextoUtils.removePontoBarraUnderlineTracoParenteseChaveCochete((String)telefone);
        if (StringUtils.isBlank((CharSequence)(telefone = TextoUtils.removeEspacos((String)telefone))) || !StringUtils.isNumeric((CharSequence)telefone)) {
            return null;
        }
        if (telefone.length() == 8 || telefone.length() == 9) {
            telefone = "00".concat(telefone);
        }
        String retorno = telefone;
        if (telefone.length() == 10 || telefone.length() == 11) {
            return StringUtils.substring((String)telefone, (int)2);
        }
        return retorno;
    }

    public static List<String> dividirEmPartes(String texto, int tamanho) {
        if (StringUtils.isEmpty((CharSequence)texto)) {
            return null;
        }
        String[] tokens = texto.split("(?<=\\G.{" + tamanho + "})");
        return Arrays.asList(tokens);
    }

    public static List<String> dividirEmPartesTipo2(String texto, int tamanho) {
        if (StringUtils.isEmpty((CharSequence)texto)) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (int start = 0; start < texto.length(); start += tamanho) {
            tokens.add(texto.substring(start, Math.min(texto.length(), start + tamanho)));
        }
        return tokens;
    }

    public static String retornaValorSemFormatacao(BigDecimal valor) {
        if (valor == null) {
            return "null";
        }
        String toString = valor.toString().replace(".", "");
        return toString;
    }

    public static String ajustaItemListaServicoModernizacaoPublica(String infRpsServicoItemListaServico) {
        if (infRpsServicoItemListaServico != null) {
            switch (infRpsServicoItemListaServico.length()) {
                case 4: {
                    String substring1 = infRpsServicoItemListaServico.substring(0, 2);
                    String substring2 = infRpsServicoItemListaServico.substring(2, 4);
                    return substring1 + "." + substring2;
                }
                case 3: {
                    String substring1 = infRpsServicoItemListaServico.substring(0, 1);
                    String substring2 = infRpsServicoItemListaServico.substring(1, 3);
                    return substring1 + "." + substring2;
                }
            }
            return infRpsServicoItemListaServico;
        }
        return null;
    }

    public static String formatarData(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "null";
        }
        String format = localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return format;
    }

    public static String formatarData(LocalDate localDate) {
        if (localDate == null) {
            return "null";
        }
        String format = localDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return format;
    }

    public static String prettyPrintJSON(String unformattedJsonString) {
        StringBuilder prettyJSONBuilder = new StringBuilder();
        int indentLevel = 0;
        boolean inQuote = false;
        block7: for (char charFromUnformattedJson : unformattedJsonString.toCharArray()) {
            switch (charFromUnformattedJson) {
                case '\"': {
                    inQuote = !inQuote;
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case ' ': {
                    if (!inQuote) continue block7;
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case '[': 
                case '{': {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    TextoUtils.appendIndentedNewLine((int)(++indentLevel), (StringBuilder)prettyJSONBuilder);
                    continue block7;
                }
                case ']': 
                case '}': {
                    TextoUtils.appendIndentedNewLine((int)(--indentLevel), (StringBuilder)prettyJSONBuilder);
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    continue block7;
                }
                case ',': {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                    if (inQuote) continue block7;
                    TextoUtils.appendIndentedNewLine((int)indentLevel, (StringBuilder)prettyJSONBuilder);
                    continue block7;
                }
                default: {
                    prettyJSONBuilder.append(charFromUnformattedJson);
                }
            }
        }
        return prettyJSONBuilder.toString();
    }

    private static void appendIndentedNewLine(int indentLevel, StringBuilder stringBuilder) {
        stringBuilder.append("\n");
        for (int i = 0; i < indentLevel; ++i) {
            stringBuilder.append("  ");
        }
    }

    public static String byteToHumano(long bytes) {
        String byteCountToDisplaySize = FileUtils.byteCountToDisplaySize((long)bytes);
        return byteCountToDisplaySize;
    }

    public static int lastIndexOfRegex(String str, String toFind) {
        Pattern pattern = Pattern.compile(toFind);
        Matcher matcher = pattern.matcher(str);
        int lastIndex = -1;
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }

    public static int lastIndexOfRegex(String str, String toFind, int fromIndex) {
        return TextoUtils.lastIndexOfRegex((String)str.substring(0, fromIndex), (String)toFind);
    }

    public static String breakStringToLines(String str, int maxLength, String newLineString) {
        StringBuilder result = new StringBuilder();
        while (str.length() > maxLength) {
            int breakingIndex = TextoUtils.lastIndexOfRegex((String)str, (String)"\\s", (int)maxLength);
            if (breakingIndex == -1) {
                breakingIndex = TextoUtils.lastIndexOfRegex((String)str, (String)"[^a-zA-Z0-9]", (int)maxLength);
            }
            if (breakingIndex == -1) {
                breakingIndex = maxLength;
            }
            result.append(str.substring(0, breakingIndex + 1));
            result.append(newLineString);
            str = str.substring(breakingIndex + 1);
        }
        if (str.length() > 0) {
            result.append(str);
        }
        return result.toString();
    }

    public static String capitalizeWords(String str) {
        String[] words;
        if (str == null || str.isEmpty()) {
            throw new RuntimeException("Valor informado \u00e9 inv\u00e1lido!");
        }
        str = str.toLowerCase();
        StringBuilder result = new StringBuilder();
        for (String word : words = str.split(" ")) {
            if (!word.isEmpty()) {
                char firstChar = Character.toUpperCase(word.charAt(0));
                result.append(firstChar).append(word.substring(1)).append(" ");
                continue;
            }
            result.append(" ");
        }
        return result.toString().trim();
    }
}

