/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util.genson;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GensonDate2Converter
implements Converter<Date> {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.000-0300");

    public void serialize(Date date, ObjectWriter objectWriter, Context context) {
        objectWriter.writeString(this.simpleDateFormat.format(date));
    }

    public Date deserialize(ObjectReader objectReader, Context context) {
        Date date = null;
        try {
            date = this.simpleDateFormat.parse(objectReader.valueAsString());
        }
        catch (ParseException e) {
            date = new Date();
        }
        return date;
    }
}

