/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util.genson;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class GensonLocalDateConverter
implements Converter<LocalDate> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public void serialize(LocalDate localDate, ObjectWriter objectWriter, Context context) {
        String formattedDate = localDate.format(FORMATTER);
        objectWriter.writeString(formattedDate);
    }

    public LocalDate deserialize(ObjectReader objectReader, Context context) {
        String dateString = objectReader.valueAsString();
        return LocalDate.parse(dateString, FORMATTER);
    }
}

