/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util.genson;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class GensonLocalDateTimeConverter
implements Converter<LocalDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.000-0300");

    public void serialize(LocalDateTime localDateTime, ObjectWriter objectWriter, Context context) {
        String formattedDateTime = localDateTime.format(FORMATTER);
        objectWriter.writeString(formattedDateTime);
    }

    public LocalDateTime deserialize(ObjectReader objectReader, Context context) {
        String dateTimeString = objectReader.valueAsString();
        return LocalDateTime.parse(dateTimeString, FORMATTER);
    }
}

