/*
 * Decompiled with CFR 0.152.
 */
package com.softjava.motor.util.genson;

import com.owlike.genson.Converter;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.softjava.motor.util.genson.GensonDate2Converter;
import com.softjava.motor.util.genson.GensonLocalDateConverter;
import com.softjava.motor.util.genson.GensonLocalDateTimeConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GensonUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(GensonUtil.class);
    private static Genson genson;

    public GensonUtil() {
        genson = new GensonBuilder().setSkipNull(true).useDateAsTimestamp(false).withConverter((Converter)new GensonDate2Converter(), Date.class).withConverter((Converter)new GensonLocalDateConverter(), LocalDate.class).withConverter((Converter)new GensonLocalDateTimeConverter(), LocalDateTime.class).create();
    }

    public GensonUtil(Converter<Date> dateConverter, Converter<LocalDate> localDateConverter, Converter<LocalDateTime> localDateTimeConverter) {
        genson = new GensonBuilder().setSkipNull(true).useDateAsTimestamp(false).withConverter((Converter)(dateConverter != null ? dateConverter : new GensonDate2Converter()), Date.class).withConverter((Converter)(localDateConverter != null ? localDateConverter : new GensonLocalDateConverter()), LocalDate.class).withConverter((Converter)(localDateTimeConverter != null ? localDateTimeConverter : new GensonLocalDateTimeConverter()), LocalDateTime.class).create();
    }

    public static Genson getGenson() {
        return genson;
    }

    public String serialize(Object obj) {
        log.info("Serializando objeto");
        String serialize = genson.serialize(obj);
        return serialize;
    }

    public T deserialize(String json, Class<T> clazz) {
        log.info("Deserializando objeto");
        Object deserialize = genson.deserialize(json, clazz);
        return (T)deserialize;
    }

    public List<T> deserialize(String json, GenericType<List<T>> list) {
        List deserialize = (List)genson.deserialize(json, list);
        return deserialize;
    }
}

